#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static DWORD dwId[] = {faerie000,faerie001,faerie002,faerie003,faerie004,faerie005,faerie006,faerie007,faerie008,faerie009,faerie010,faerie011,faerie012,faerie013,faerie014,faerie015,faerie016,faerie017,faerie018,faerie019,faerie020,faerie021,faerie022,faerie023,faerie024,faerie025,faerie026,faerie027,faerie028,faerie029,faerie030,faerie031,faerie032,faerie033,faerie034,faerie035,faerie036,faerie037,faerie038,faerie039};
#define NB_FAERIES (sizeof(dwId)/sizeof(DWORD))
static Obj3d Faerie[NB_FAERIES];
static float Matrix[16], Matrix2[16];

static float *sow, *tow;
static DWORD *A, *B, *C;

static Obj3d *pSphere;

void LInit_Faerie()
{
	DWORD Cpt1, Cpt2;
	DWORD dwDummy;
	FILE *file;
	DWORD dwNbVertices, dwNbFaces;
	DWORD dwTmp;

	pSphere = GenerateSphere(13, 13, 300, 300, 512, 512);

	for(Cpt1=0;Cpt1<NB_FAERIES;Cpt1++)
	{
		LoadObject(&Faerie[Cpt1], dwId[Cpt1], faerieface);
	}

	PrepareTextureFromArray(g_PicFaerie, 256, 256, &g_TextureFaerie);
	PrepareTextureFromArray(g_PicFlotte, 256, 256, &g_TextureFlotte);

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, faeriemap, &dwDummy);

	fread(&dwNbVertices, 4, 1, file);
	fread(&dwNbFaces, 4, 1, file);

	sow = (float*)malloc(dwNbVertices*sizeof(float));
	tow = (float*)malloc(dwNbVertices*sizeof(float));
	A = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	B = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));
	C = (DWORD*)malloc(dwNbFaces*sizeof(DWORD));

	for(Cpt1=0;Cpt1<dwNbVertices;Cpt1++)
	{
		fread(sow+Cpt1, 4, 1, file);
		fread(tow+Cpt1, 4, 1, file);
	}

	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		fread(A+Cpt1, 4, 1, file);
		fread(B+Cpt1, 4, 1, file);
		fread(C+Cpt1, 4, 1, file);
	}

	for(Cpt2=0;Cpt2<NB_FAERIES;Cpt2++)
	for(Cpt1=0;Cpt1<dwNbFaces;Cpt1++)
	{
		Faerie[Cpt2].pFace[Cpt1].SowA = sow[C[Cpt1]];
		Faerie[Cpt2].pFace[Cpt1].TowA = tow[C[Cpt1]];
		Faerie[Cpt2].pFace[Cpt1].SowB = sow[B[Cpt1]];
		Faerie[Cpt2].pFace[Cpt1].TowB = tow[B[Cpt1]];
		Faerie[Cpt2].pFace[Cpt1].SowC = sow[A[Cpt1]];
		Faerie[Cpt2].pFace[Cpt1].TowC = tow[A[Cpt1]];
	}

	fclose(file);

	BeIdentityMatrix(Matrix);
	RotateZMatrix(Matrix2, Matrix, -2048);
	RotateXMatrix(Matrix, Matrix2, 2048);
	for(Cpt1=0;Cpt1<NB_FAERIES;Cpt1++)
		ApplyMatrix(Faerie+Cpt1, Matrix);
}

void QInit_Faerie()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grConstantColorValue(0xffffff);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	DownloadTexture(&g_TextureFaerie);
	DownloadTexture(&g_TextureFlotte);
}

void Effect_Faerie()
{
	grDepthBufferFunction(GR_CMP_ALWAYS);
	SelectTexture(g_TextureFlotte);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	BeIdentityMatrix(Matrix);
	RotateYMatrix(Matrix2, Matrix, g_demostate.TickInEffect/2);
	RotateZMatrix(Matrix, Matrix2, g_demostate.TickInEffect/2);
	DrawWithMatrix(pSphere, Matrix, 0,0,0);

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grDepthBufferFunction(GR_CMP_LESS);
	SelectTexture(g_TextureFaerie);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, 3.f*CosTable[g_demostate.TickInEffect&8191], 
		3.f*SinTable[g_demostate.TickInEffect&8191], 100.f);
	DrawWithMatrix(&Faerie[(g_demostate.TickInEffect/64)%NB_FAERIES], Matrix, 0, 0, 1);

	SelectTexture(g_TextureFlotte);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect);
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect/2);
	DrawWithMatrix(pSphere, Matrix, 0,0,0);
}

void ByeBye_Faerie()
{
	FreeTexture(&g_TextureFlotte);
	FreeTexture(&g_TextureFaerie);
}